<?php

require_once('functions.php');
require_once('config.php');

/*
 * Functions that uses the viewer.
 */

/*
 * Prints exif information
 *
 */

function print_exif_info( $filepath, $phid) {
    global $PHID_STATS, $PHID_INFO,$PHID_CAPTIONS, 
      $TEMPLATE_DIR, $MAX_IMG_SIZE;

    $path_info=pathinfo($filepath);
    $sz = getimagesize ($filepath);

    $gid_dir=$path_info['dirname']. "/";

    $D_FILENAME=$path_info['basename'];
    $D_FILESIZE=(int)(filesize($filepath)/1024);
    $D_HEIGHT=$sz[1];
    $D_WIDTH=$sz[0];
    $D_VISITS=get_data($gid_dir . $PHID_STATS,$phid );
    $D_MAX_IMG_SIZE=$MAX_IMG_SIZE;
    $D_DESC=get_data($gid_dir . $PHID_CAPTIONS, $phid);
    $I_FILENAME=_y('Filename');
    $I_FILESIZE =_y('File size');
    $I_IMAGE_SIZE =_y('Image size');
    $I_VISITS =_y('Visits');
    $I_DESC =_y('Description');

    include ($TEMPLATE_DIR . 'phid_info.php');


    /*

    //Temporally unavailable --
    echo "<div><b>Informacin exif:</b><br />\n";
    $exif = exif_read_data ($filepath,'IFD0');
    if ($exif===false) echo "No header data found.<br />\n";
    else {
	$exif = exif_read_data ($filepath,0,true);
	foreach($exif as $key=>$section) {
	    foreach($section as $name=>$val) {
		echo "$key.$name: $val<br />\n";
	    }
	}
    }
    */


} //End function



/**
 * prints comments form 
 * 
 * optionally can include as argument field, an array with this keys:
 *  +tit comment title.
 *  +aut author
 *  +date comment date
 *  +mail author mail
 *  +web author web
 *  +msg comment text
 * 
 * @param string $D_URL url of the action.
 * @param array $fields content of the fields,
 */

function print_form($D_URL,$fields=array()) {
global $TEMPLATE_DIR;
 
//echo "<pre>";print_r($fields);echo "</pre>"; //Debug Line;

 $D_TITLE=$fields['tit'];
 $D_AUTHOR=$fields['aut'];
 $D_EMAIL=$fields['mail'];
 $D_DATE=$fields['date'];
 $D_WEB=$fields['web'];
 $D_COMMENT=$fields['msg'];
   
 $I_ADD_COMMENT =_y('Add yout comment!');
 $I_TITLE =_y('Comment title');
 $I_AUTHOR =_y('Author');
 $I_EMAIL =_y('E-mail');
 $I_WEB =_y('Web');
 $I_COMMENT =_y('Comment');
 $I_REQUIRED =_y('Fields with * are required');
 $I_SEND=_y('Send');

include($TEMPLATE_DIR . 'add_comment_form.php');

} //Fin funcion print form

/*
 * Prints one comment
 */
function print_comment($line, $D_ADMIN_HTML="") {
     global $TEMPLATE_DIR, $SEPARATOR;
     
     list($title,$author,$date,$mail,$web,$comment)=array_values(explode($SEPARATOR,$line));

    $mail=trim($mail);
    if (strlen($mail)>0)
      $D_LINKMAIL="<a href=\"mailto:{$mail}_NOSPAM_\">$author</a>";
    else $D_LINKMAIL=$author;
    if (strlen($web)) $D_LINKWEB="web: <a href=\"$web\">$web</a>";
     $D_TITLE=$title;
     $D_AUTHOR=$author;
     $D_DATE=$date;
     $D_COMMENT=$comment;
     $I_DATE=_y('Date');
     $I_COMMENT=_y('Comment');

    include($TEMPLATE_DIR . 'print_comment.php');

} //Fin print_comment


function print_all_comments($file,$gid, $phid) {
    global $SEPARATOR ;

    heading(_y("Image comments"));
    if (!file_exists($file)||(filesize($file)==0))  {
	heading(_y("There are no messages! Give us your opinion!"),4);
    }
    else {
    	//We read the file. In each line there is a comment.
	if (($fd=fopen ($file,"r"))===false) {
	    error(_y("Opening comments file"));
	}
	while(!feof($fd)) {
	    $line=fgets($fd,2048);
             //Separe fields in each line
	    if(strlen($line)<3) continue; //Just if there is a blank line.
	    print_comment($line);
	} //fin while
	fclose($fd);
    }//fin else
    $url="add_comment.php?gid=$gid&amp;phid=$phid";
    print_form($url);
}
/**
 * prints gallery navigation bar witch consist in next previous
 * and index of galleries links
 * 
 * @param integer gid gallery identifier
 * @global string gid => directory data file
 * @global string user template directory
 * @return bool true if ok, false if not :D
*/

function print_gallery_navigation_bar( $gid) {
  global $GID_DIRS,$TEMPLATE_DIR;

  $D_PREV=_y("Previous Gallery");
  $D_NEXT=_y("Next Gallery");
  $D_UP="<a href=\"gallery.php\">". _y("Index of Galleries")."</a>";
  
  if (!($nav_info=get_prev_and_next($GID_DIRS,$gid))){
    warning(_y("could not show gallery navigation bar"));
    return(false);
  }
  if (!($nav_info[0]<0)) {
    $D_PREV="<a href=\"view.php?hit=yes&amp;gid=".$nav_info[0]."\">$D_PREV</a>";      
  }
  if (!($nav_info[2]<0)) {
    $D_NEXT="<a href=\"view.php?hit=yes&amp;gid=".$nav_info[2]."\">$D_NEXT</a>";      
  }
  include($TEMPLATE_DIR . "prev_up_next_bar.php");
  return(true);
}


/**
 * prints gallery navigation bar witch consist in next photo,
 * previous photo and gallery index links.
 * 
 * @param integer gid this gallery identifier
 * @param integer phid this photo identifier
 * @param string gid_dir $BASE_DIR + gallery_dir
 * @global string gid => directory data file
 * @global string user template directory
 * @return bool true if ok, false if not :D
*/

function print_navigation_bar ($gid,$phid,$gid_dir,$base_url='view.php?') {
  global $PHID_FILENAMES,$TEMPLATE_DIR;

    $D_PREV=_y('Previous Image');  
    $D_NEXT=_y('Next Image');  
    $D_UP="<a href=\"{$base_url}gid=$gid\">". _y('Up')."</a>";  
    

    if (!($nav_info=get_prev_and_next($gid_dir . $PHID_FILENAMES,$phid))){
      warning(_y("could not show gallery navigation bar"));
      return(false);
    }
    if (!($nav_info[2]<0)) {
      $D_NEXT="<a href=\"{$base_url}gid=$gid&amp;phid=". $nav_info[2] . 
	"\" title=\"$D_NEXT\">$D_NEXT</a>";
    }
    if (!($nav_info[0]<0)) {
      $D_PREV="<a href=\"{$base_url}gid=$gid&amp;phid=" . $nav_info[0] . 
	"\" title=\"$D_PREV\">$D_PREV</a>";
    }
    include($TEMPLATE_DIR . "prev_up_next_bar.php");
    return(true);
}


function print_page_navigation_bar($gid_dir,$gid,$actual_page){
  global $NUM_COLUMNS, $NUM_FILES, $GID_INFO_FILE, $TEMPLATE_DIR;

  //$NUM_IMG=0 => only one big page.
  if ($NUM_FILES==0) return(true);
  //Calculate number of images/page
  $img_per_page= $NUM_FILES * $NUM_COLUMNS;
  //echo "images/page: $img_per_page<br />";

  //Check if there are enougth images for more than one page.
  include($gid_dir . $GID_INFO_FILE);
  if ($img_per_page>=$gid_info['num_images']) return(true);

  $D_PREV=_y('Previous page');
  $D_NEXT=_y('Next page');
  
  $last=(int)($gid_info['num_images']/$img_per_page);

  if ($actual_page<$last){
      $D_NEXT="<a href=\"view.php?gid=$gid&amp;page=".($actual_page+1) . 
	"\" title=\"$D_NEXT\">$D_NEXT</a>";
  }
  if ($actual_page>0) {
    $D_PREV="<a href=\"view.php?gid=$gid&amp;page=".($actual_page-1) . 
      "\" title=\"$D_PREV\">$D_PREV</a>";
  }
  include($TEMPLATE_DIR . "prev_up_next_bar.php");
 
  return(true);

}

function print_zoom_bar($img_path) {
  global $TEMPLATE_DIR,$MAX_IMG_SIZE;
  if(!($sz=getimagesize($img_path)))
     return(false);
  
  $D_WIDTH=$sz[0];
  $D_HEIGHT=$sz[1];
  $D_MAX_IMG_SIZE=$MAX_IMG_SIZE;

  $D_ZOOM_IN=_y('Zoom in');
  $D_ZOOM_OUT=_y('Zoom Out');
  $D_REAL=_y('Real size');

  include ($TEMPLATE_DIR . 'zoom_bar.php');
  return(true);
}

?>
