<?php

/**
 * Here we have de code that shows a gallery index or an image with its
 * comments
 * 
 * On query string receives: $gid [ $phid || $page ] 
 * 
 * Actions: 
 *
 * if only is set gid => print gallery index.
 * if is set gid and phid => show image, image info and comments
 * if gid and page are set => show that page
 *
 * if gallery has password then check if user filled gallery password form
 * variable, $form_pw, is the same as the stored in the $GID_INFO_FILE
 * of the gallery. 
 *   
 * @package user
 */

//session_start();
require_once('functions.php');
require_once('locale.php');
require_once('config.php');
require_once('view_func.php');

//_GET[varname] => varname
//$gid=$_GET['gid'];
$phid=$_GET['phid'];
$page=$_GET['page'];
$hit=$_GET['hit'];
$form_pw=$_POST['form_pw'];


$case=0;
// 0 -> View gallery identified with "gid"
if (!isset($gid)) error(_y("GID not set"));
// 1 -> View photo of the gid library identified whith "phid";
if (isset($phid)) $case=1;
//Default page 0;
if (!isset($page)) $page='0';

//Obtain gallery directory and information about this gallery.
if (!($dir=get_data($GID_DIRS,$gid))) 
    error(_y('Getting gallery directory'));
    

$gid_dir= $BASE_DIR . $dir;
include($gid_dir . $GID_INFO_FILE);
//echo "<br>form:$form_pw-{$gid_info['gallery_password']}-ses:". $HTTP_SESSION_VARS['y_gallery_pwd'];

//Check if gallery has an access password and user inserted it.
//form_pw: password introduced by user in a form.
//gallery_password: password stored in $GID_INFO_FILE
if (!check_admin_login()) { //If user is admin, allow.
  if (strlen($gid_info['gallery_password'])>0) {
    //if gallery_has password => check
    if (!check_gallery_password($gid_info['gallery_password'],$form_pw)){ //if password
      include($TEMPLATE_DIR . 'face_begin.php');
      error(_y("Password incorrect."));
    }
  }
}

switch($case) {

 case 0: {
     //Only count a visit of the gallery when hit is set.
     if ($hit=="yes") {     //Stats
	 add_listed_visit($GID_STATS,$gid);
	 header("Location: ./view.php?gid=$gid");
	 die;
     }
     include($TEMPLATE_DIR . 'face_begin.php');
//     heading($gid_info['title']);
//     print_main_menubar();
//     print_gallery_navigation_bar($gid);

     //Now show Gallery thumbnails
     if (!gallery_thumbs($gid,$page))
       error(_y("Gallery data not found. Please create again this gallery"));
//     print_page_navigation_bar($gid_dir,$gid,$page);
//     print_gallery_navigation_bar($gid);
include($TEMPLATE_DIR . 'face_end.php');
     break;
 }
 case 1: {

     $phid_filename= get_data($gid_dir . $PHID_FILENAMES, $phid);
     $phid_visits=get_data($gid_dir . $PHID_STATS, $phid);
     $phid_comments=get_data($gid_dir . $PHID_COMMENTS, $phid);
     $img_path=$gid_dir . $phid_filename;
     $img_url=$gid_dir . rawurlencode($phid_filename);
//     heading($gid_info['title'] . "- <small>$phid_filename</small>");
     $I_TITLE= $gid_info['title'] . " - $phid_filename";
     include($TEMPLATE_DIR . 'face_view_begin.php');
//     print_main_menubar();
//     print_navigation_bar($gid,$phid,$gid_dir);
     echo "<a href=\"#\" onClick=\"self.close()\"><img border=0 src=\"".$img_url."\" alt=\"$phid_filename\" id=\"myimage\" class=\"image\" onload=\"preload('$img_url')\"></a>";
//     print_zoom_bar($img_path);
//     print_navigation_bar($gid,$phid,$gid_dir);
//     print_exif_info($img_path,$phid);
     if ($gid_info['no_comments']!="on") {
     print_all_comments($gid_dir . $gid ."_" . $phid, $gid, $phid);
     }
     //print_navigation_bar($gid,$phid, $gid_dir);
     //Stats
     add_listed_visit( $gid_dir . $PHID_STATS, $phid);
include($TEMPLATE_DIR . 'face_view_end.php');
 }
}


?>
