<?php
/**
 * These functions are common to the different files: admin an user packages.
 * 
 * @package common
 */

/***/
require_once('config.php');
require_once('locale.php');
require_once('global.php');


/**
 * Autentifies user login
 * 
 * Checks if $user and $password are the same as the ones stored
 * in config.php. If true, sets a session variable or cookie variable
 * depending on the value of the global variableUSE_COOKIE  
 * If no arguments are passed then it checks if user has that session var.
 *
 * @param string $user admin 
 * @param string $password 
 * @global string config.php admin user
 * @global string config.php admin password
 * @global array cookies
 * @global array sessions
 * @global bool true if cookies preferred. False if sessions preferred.
 * @return bool true if authentification OK. False if not OK.
 *
 */

function check_admin_login($user='',$password='') {
     global $USER, $PASSWORD, $HTTP_COOKIE_VARS,$HTTP_SESSION_VARS,$USE_COOKIES;

    if ($USE_COOKIES){ // Use cookies
	if ((strcmp($USER,$HTTP_COOKIE_VARS['y_user'])==0)&&
	    (strcmp($PASSWORD,$HTTP_COOKIE_VARS['y_password'])==0)){
	    setcookie('y_user',$USER,time()+3600);
	    setcookie('y_password', $PASSWORD,time()+3600);
	    return(true);
	}
	if ((strcmp($USER,$user)==0)&&(strcmp($PASSWORD,$password)==0)) {
	    setcookie('y_user',$USER,time()+3600);
	    setcookie('y_password', $PASSWORD,time()+3600);
	    $HTTP_COOKIE_VARS['y_user']=$USER;
	    $HTTP_COOKIE_VARS['y_password']=$PASSWORD;
	    return(true);
	}
	return(false);
	
    }
    else { //Use session variables
	if ((strcmp($USER,$HTTP_SESSION_VARS['y_user'])==0)&&
	    (strcmp($PASSWORD,$HTTP_SESSION_VARS['y_password'])==0)){
	    $HTTP_SESSION_VARS['y_user']=$USER; //Refresh values 
	    $HTTP_SESSION_VARS['y_password']=$PASSWORD;
	    return(true);
	}
	
	if ((strcmp($USER,$user)==0)&&(strcmp($PASSWORD,$password)==0)) {
	    $HTTP_SESSION_VARS['y_user']=$USER;
	    $HTTP_SESSION_VARS['y_password']=$PASSWORD;
	    return(true);
	}
	return(false);
    }   
}

/**
 * 
 * Includes the template file located in $TEMPLATE_DIR
 * Do not include the .php extension.
 * 
 * @global string $TEMPLATE_DIR template directory location
 * @param string $file filename without .php extension.
 * @return bool false if file does not exist
 */

function template($file) {
    global $TEMPLATE_DIR, $VERSION;
    
    $full_path= $TEMPLATE_DIR . $file . '.php';
    if (!file_exists($full_path)) return(false);
    include($full_path);
    return(true);
}

/**
 * decode HTML->entities.Opposite to htmlentities function
 */

function unhtmlentities ($string) {
    $trans_tbl = get_html_translation_table (HTML_ENTITIES);
    $trans_tbl = array_flip ($trans_tbl);
    return strtr ($string, $trans_tbl);
}



/*
 * Prints an error and dies.
 * 
 * @param string $message Error Message
 * @global string template directory.
 * @global string version of yapig
 * @return none
 */

function error ($message) {
    global $TEMPLATE_DIR, $VERSION;
    
  $I_ERROR=_y("Error");

    echo "<h3>$I_ERROR: $message</h3>";
    include($TEMPLATE_DIR . 'face_end.php');
    die;

}


/*
 * Outputs warning in a parragraf, but does not die.
 *
 * @param string $text output text
 *
 * @return none
 */

function warning($text) {
    $I_WARNING=_y('Warning');
    echo "<p class=\"msg\"><strong>$I_WARNING</strong>: $text</p>";
}

/*
 * outputs a message in a parragraf.
 *
 * @param string $text Output text
 * @return none
 */

function msg($text) {
    echo "<p class=\"msg\"><strong>YaPiG:</strong> $text</p>";
}

/*
 * Outputs a heading <HX> in a parragraf. 
 *
 * @param string $text text of the heading
 * @param integer $size (Optional) biggest=1 smallest=6
 * @return none
 */

function heading($text, $size=1) {
    echo "<h{$size}>$text</h{$size}>";
}


/**
 * Prints main menu navigation bar
 * 
 * If gallery password is set, then it allows logout.
 * If admin password is set, then it allos admin logout.
 * 
 * @global config.php template directory
 * @global config.php home page
 * @global session global var 
 * @global cookie vars
 */

function print_main_menubar() {
    global $TEMPLATE_DIR, $HOME, $HTTP_SESSION_VARS,$USE_COOKIES,
      $HTTP_COOKIE_VARS;
    
    $I_MAIN_MENU=_y('main menu');
    $I_GALLERY_INDEX=_y('Gallery index');
    $I_HOME_PAGE=_y('Home page');
    $D_HOME_PAGE=$HOME;
    $I_ADMIN=_y('Admin');

    //Logout links
    $I_ADMIN_LOGOUT=_y('Admin logout');
    $I_GALLERY_LOGOUT=_y('Gallery logout');
   $admin_logout_str="<a href=\"admin.php?action=logout\">$I_ADMIN_LOGOUT</a> |";
 $gallery_logout_str="<a href=\"gallery.php?action=logout\">$I_GALLERY_LOGOUT</a>";

   if ($USE_COOKIES){

     if (strlen($HTTP_COOKIE_VARS['y_user'])>0)
     $D_ADMIN_LOGOUT=$admin_logout_str;
     
     if (strlen($HTTP_COOKIE_VARS['y_gallery_pwd'])>0){
       $D_GALLERY_LOGOUT=$gallery_logout_str;
     }
   }
   else{ //Using Session variables 
     if (strlen($HTTP_SESSION_VARS['y_user'])>0)
       $D_ADMIN_LOGOUT=$admin_logout_str;
     
     if (strlen($HTTP_SESSION_VARS['y_gallery_pwd'])>0){
       $D_GALLERY_LOGOUT=$gallery_logout_str;
     }
     //echo "y_gallery_pwd:" . $HTTP_SESSION_VARS['y_gallery_pwd'];
                            
   }
 //Print main menu bar.
 include($TEMPLATE_DIR . 'main_menu_bar.php');
 
}

/**
 *
 * gets data from a file whith this format: id<EQUAL>data
 *
 *  The functions searchs for id and returns data.
 *
 * Example:
 *    id=>returned_data
 *    1=>art_gallery
 *    2=>porn_galler
 *
 * @param string $file Path to file
 * @param string $id Identifier we are looking for.
 *
 * @return string or false if not found.
 *
 * @global string EQUAL attribute value delimiter. As default "=>"
 *
 */

function get_data($file,$id) {

    global $EQUAL;

    if (!file_exists($file)) return(0);
    if(!($all=file($file))) return(0);
    $i=0;
    while($i<sizeof($all)) {
	$one=explode($EQUAL,trim($all[$i]));
	if (strcmp($id,$one[0])==0) return($one[1]);
	$i++;
    }
    return (0);
}

/**
 * gets data from a file whith this format: id<EQUAL>data
 * @param string $file full path to file
 * @returns array with data or false if there was any problem.
 */

function get_all_data($file) {

    global $EQUAL;
    //echo "get_all_data( file: $file)";
    if (!file_exists($file)) return(false);
    if(!($all=file($file))) return(false);
    $i=0;
    $one=array();
    while($i<sizeof($all)) {
	$tmp=explode($EQUAL,trim($all[$i]));
	$one[$tmp[0]]=$tmp[1];
	$i++;
    }
    //echo "<pre>";print_r($one);echo "</pre>"; //debug Line
    return ($one);
}

/**
 * Deletes an entry of a file with this line format: id<EQUAL>data
 *
 * @param string $file path of the file.
 * @param string $id identifier (leftside).
 * 
 * @return boolean returns true if found and deleted. False if any problem
 */

function delete_data($file, $id) {

    global $EQUAL;

    if (!file_exists($file)) return(false);
    if(!($all=file($file))) return(false);
    //print_r($all);
    if(!($fd=fopen($file,"w+"))) return(false);
    $i=0;
    while($i<sizeof($all)) {
	$one=explode($EQUAL,trim($all[$i]));
	if ($id!=$one[0]){
	  fputs($fd,$all[$i]);
	}
	//else {echo "###deleted###";}
	$i++;
    }
    fflush($fd);
    fclose($fd);
    return (true);
}

/**
 * adds a line to the file with the format $key=>$value
 * if the file does not exist, creates it.
 * 
 * @param string file full path of file.
 * @param integer key identifier (gid or phid)
 * @param value data asociated with the key.
 * @global separator, set as default: "=>"  
 *
 * @returns boolean true if ok, false if any problem.
 */

function add_data($file, $key, $value) {
  global $EQUAL;

  if ((!file_exists($file))||(filesize($file)==0)) {
    if(!($fd=fopen($file,"w+"))) return(false);
    
    fputs($fd, $key . $EQUAL . $value . "\n");
    fclose($fd);
    return(true);
  }
  $all=file($file);
  //print_r($all);
  if(!($fd=fopen($file,"w+"))) return(false);
  fputs($fd, $key . $EQUAL . $value . "\n");
  if (is_array($all)) foreach ($all as $line) fputs($fd, $line);
  fclose($fd);
  return(true);
  
}

/*
 * Gets previous and next keys of an array
 * 
 * This is used when you want to search previous key on a file
 * with line format: key $EQUAL value
 * 
 * For example: if file contents are: 
 *      1=>p
 *      2=>q
 *      3=>r
 *      5=>s
 * and key param is '3' the function will return: array(2,3,5).
 * if key param is 2 the function will return array(-1,1,2);
 * @param array $file text file with line format: key $EQUAL value\n 
 * @param integer $key searched key
 * @returns mixed false if any problem. Array with keys: previous,key,next  
 * 
 */

function get_prev_and_next($file,$key) {

   if (!($the_array=get_all_data($file))) return(false);
   $keys=array_keys($the_array); //we only need keys
   $ret_array=array();//Initialize returned array.
   $keys_size=count($keys);
   $i=0; //init counter
   while($i<$keys_size){ 
     if ($keys[$i]==$key){ //Search for the key.
       if($i>0) $ret_array[0]=$keys[$i-1]; //Previous 
       else $ret_array[0]=-1; 
       $ret_array[1]=$key;
       if ($i+1<$keys_size) $ret_array[2]=$keys[$i+1]; //Next
       else $ret_array[2]=-1; 
       //echo "<pre>key_size=$keys_size\n";
       //print_r($keys);
       //print_r($ret_array);echo "</pre>"; //debug Line
       return($ret_array);
     }
     $i++;
   }
}

/**
 * This function updates a file with format:
 * type=>counter
 * 
 * @param string $file path to file with that format.
 * @param array $data array with format data['type']=counter_value
 * @return int -1 if problems;  
 */

function update_counter_file($file,$data){
  global $EQUAL;
  
  if(!($fd=fopen($file,"w"))) return(-1);
  foreach($data as $key => $value) 
    fputs($fd,$key . $EQUAL . $value . "\n\r"); //Actualizamos fichero
  fclose($fd);
}


/**
 * Increases counter file
 * 
 * File has line format: tipo => integer
 * There is a special line, witch is alwais incremented
 * and contains the sum of all counters.
 * @param string $file path to counter file
 * @param string $tipo identifier, usually will be a gid or phid. 
 * @return boolean true if ok, false if not
 */

 function add_listed_visit($file, $tipo) {
  global $EQUAL,$TOTAL_LIST;

  //echo "add_listed_visit($file, $tipo)";
     
     $visits=get_all_data($file);
     $visits[$TOTAL_LIST]++;
     $visits[$tipo]++;
     if (!update_counter_file($file,$visits)) return(false);
     //echo "<pre>visits: \n";print_r($visits);echo "</pre>";
     return(true);
 }

/**
 * Decreases a counter identified by type in the file an amount.
 * @param string $file path to file
 * @param string $type counter identifier (gid or phid in general)
 * @param interger $amount how many units it is decremented;
 */

function decrease_counter($file, $type, $amount=1) {
  global $TOTAL_LIST;
 
  //echo "decrease_counter($file, $tipo)";
     
     $visits=get_all_data($file);
     $visits[$TOTAL_LIST]-=$amount;
     $visits[$type]-=$amount;
     //echo "<pre>visits: \n";print_r($visits);echo "</pre>";
     if (!update_counter_file($file,$visits)) return(false);
     
     return(true);

}

/**
 * Checks if user has introduced a correct password in the gallery 
 * password form or if user was authentified previously. Sets a cookie
 * or a session cookie.
 * 
 * @global array session
 * @global array cookies
 * @global bool true if want to use cookies. False if want to use sessions
 * @return bool true if ok false if password is incorrect
 * 
 */
function check_gallery_password($gallery_password,$form_pw=''){
    global $HTTP_SESSION_VARS,$HTTP_COOKIE_VARS,$USE_COOKIES;
    
    if (strlen($gallery_password)==0) return(true);
    
    //Check if user already introduced the password
    if ($USE_COOKIES) {
	if (strcmp($gallery_password,$HTTP_COOKIE_VARS['y_gallery_pwd'])==0){
	    //setcookie('y_gallery_pwd',$gallery_password,time()+300);
	    return(true);
	}
	if (strcmp($gallery_password,$form_pw)==0) {
	  setcookie('y_gallery_pwd',$gallery_password,time()+450);
	  $HTTP_COOKIE_VARS['y_gallery_pwd']=$gallery_password;
	  return(true);
	}    
	return(false);	
    }
    else {
	if (strcmp($gallery_password,$HTTP_SESSION_VARS['y_gallery_pwd'])==0)
	    return(true);
	if (strcmp($gallery_password,$form_pw)==0) {
	    $HTTP_SESSION_VARS['y_gallery_pwd']=$gallery_password;
	    return(true);
	}    
	return(false);
    }
}

/**
 * returns the path to the thumbnail.
 * 
 * if phid is negative then returns path to password protected
 * gallery. 
 * 
 * @param string $gid_dir path to gid (ie: photos/mygallery/)
 * @param string $phid image identificator
 * @param bool $rawurlencode if true then apply rawurlencode function.
 * @return string with the filename. if not found returns not_available.jpg.
 * @global phid->filename correspondence
 * @global thumbnail prefix
 * @global localtion of template
 */
    
function get_thumb_path($gid_dir,$phid,$rawurlencode='false'){
  global $PHID_FILENAMES, $THUMB_PREFIX, $TEMPLATE_DIR;
  
  if ($phid<0) return($TEMPLATE_DIR . 'password.jpg');
  if(!($filename=get_data($gid_dir . $PHID_FILENAMES, $phid))){
    return($TEMPLATE_DIR . 'not_available.jpg');
  }
    $filename=$THUMB_PREFIX . $filename;
    
    if (!file_exists($gid_dir . $filename))
    return($TEMPLATE_DIR . 'not_available.jpg');
    if ($rawurlencode) $filename=$gid_dir . rawurlencode($filename); 
  return($filename);
}

/**
 * Show an index of galleries
 *
 * This function shows an index of all galleries. It shows main information
 * of each gallery and a thumbnail
 *
 * @param string $base_url Destination link will be $base_url.$gid 
 * @param string $gid_dirs_file file with gid and directories (ie $GID_DIRS) 
 * @param string $actions Aditional HTML, 
 * @return bool true if all went ok
 */

function index_of_galleries($base_url,$gid_dirs_file,$actions=''){
  global $BASE_DIR,$EQUAL,$GID_INFO_FILE,$GID_STATS, $PHID_STATS,$PHID_COMMENTS,$TOTAL_LIST;
  global $HTTP_SESSION_VARS,$TEMPLATE_DIR;

  //Now get list of gallery ids and directorys;
  if (!($gid_list=get_all_data($gid_dirs_file))) return(false);

    foreach ($gid_list as $gid => $gid_dir) {
	$D_PASSWORD_FORM=''; //Set to NULL
	$gid_dir=$BASE_DIR . $gid_dir; 
	if (!is_dir($gid_dir)) {  
	    warning(_y("Gallery does not exist: ") . $gid);
	    continue;	 
	}
		
	if (!file_exists($gid_dir . $GID_INFO_FILE)) return(false);
	require( $gid_dir . $GID_INFO_FILE);
	  
	//Convert info loaded from $GID_INFOFILE in standard template names
	$D_URL=$base_url .$gid;
	$D_VISITS=get_data($GID_STATS,$gid);
	$D_COMMENTS=get_data($gid_dir. $PHID_COMMENTS, $TOTAL_LIST);
	$D_TITLE=$gid_info['title'];
	$D_AUTHOR=$gid_info['author'];
	$D_NUMBER_IMAGES=$gid_info['num_images'];
	$D_DATE=$gid_info['date'];
	$D_DESC=stripslashes($gid_info['desc']);
	$D_THUMB=get_thumb_path($gid_dir, $gid_info['thumb_phid']);
       
	$D_ACTIONS= $actions;

	$I_NUMBER_IMAGES=_y('Number of images');
	$I_TITLE=_y('Title');
	$I_AUTHOR=_y('Author');
	$I_VIEW_GALLERY=_y('View this gallery');
	$I_GALLERY=_y('Gallery');
	$I_VISITS=_y('Visits');
	$I_COMMENTS=_y('Comments');
	$I_DATE=_y('Date');
	$I_DESCRIPTION=_y('Description');

	
	//If gallery has a password then show password form	
	if (!check_gallery_password($gid_info['gallery_password']) 
	    && !check_admin_login())
	  {
	    //User didnt introduced the password.
	    $form_action=$D_URL;
	    $D_THUMB= $TEMPLATE_DIR . "password.jpg";
	    $I_ALERT=_y('This Gallery requires password. Please fill the password field and press the validate button. Thank you.');
	    $D_URL="javascript:alert('$I_ALERT');";
	    $I_VALIDATE=_y('Validate');
	    $I_GALLERY_PASSWORD=_y('Gallery password');

	    $D_PASSWORD_FORM=<<<PWFORM
	      
        <form class="pwform" method="POST" action="$form_action">
	{$I_GALLERY_PASSWORD}:
	<input type="password" value="" name="form_pw" />
        <input type="submit" value="$I_VALIDATE" class="formbutton" />
         </form>
PWFORM;
	}
	
	include($TEMPLATE_DIR . 'gid_index.php');
    }
    return(true);
}

/**
 * Shows a table with the thumbnails of the gid specified
 *
 * This function shows the thumbnails of the images of a gallery. It shows
 * number of comments and number of visits of each image. It also makes a link
 * to allow viewing the bigger image.
 *
 * @param int $gid number of the gid gallery.
 *
 **/

function gallery_thumbs ($gid,$page) {
    global $BASE_DIR, $GID_DIRS, $GID_INFO_FILE, $PHID_FILENAMES,
      $EQUAL, $PHID_STATS, $PHID_COMMENTS, $THUMB_PREFIX,
      $NUM_COLUMNS, $NUM_FILES,$TEMPLATE_DIR,
      $PHID_CAPTIONS;

    if (!($gid_dir=get_data($GID_DIRS,$gid))) return(false);
    $gid_dir= $BASE_DIR . $gid_dir;
    if (!file_exists($gid_dir . $GID_INFO_FILE)) return(false);
    include($gid_dir . $GID_INFO_FILE);    
    if (!($phid_filenames=get_all_data($gid_dir . $PHID_FILENAMES)))
      return(false);
        
    $i=0;
    echo "<table border=0 cellpadding=0 cellspacing=3 width=100%><tr>";

    // I18n -  
    $I_VIEW_BIGGER=_y('View image bigger');
    $I_IMAGE=_y('Image');
    $I_HITS=_y('Hits');
    $I_COMMENTS=_y('Comments');
    
    if($NUM_FILES>0){
	$img_per_page=$NUM_COLUMNS * $NUM_FILES;

	$page_begin=$page*$img_per_page;
	$page_end=$page_begin + $img_per_page;
	$phid_filenames_len=count($phid_filenames);
	if ($phid_filenames_len < $page_end) {
	    $page_end=$phid_filenames_len;
	}
	//echo "page_begin=$page_begin;page_end=$page_end<br />";
	$i=0;
	foreach($phid_filenames as $phid => $filename) {
	    if (($i>=$page_begin) && ($i<$page_end) )
		$phid_filenames_tmp[$phid]=$filename;
	    $i++;
	}
	$phid_filenames=$phid_filenames_tmp;    
    }
    $i=0;
    foreach ($phid_filenames as $phid => $phid_filename) {
	//echo "phid: $phid; filename= $phid_filename<br />"; // Debug Line
	$phid_visits=get_data($gid_dir . $PHID_STATS, $phid);
	$phid_comments=get_data($gid_dir . $PHID_COMMENTS, $phid);
	$img_path=$gid_dir . $phid_filename;
	$thumb_name=$THUMB_PREFIX . $phid_filename;
// Bicz Balzs
$imagesize = getimagesize($img_path);
// echo "file: $img_path; sz=$imagesize[0]; m=$imagesize[1]<br />";
$D_IMAGE_WIDTH=$imagesize[0];
$D_IMAGE_HEIGHT=$imagesize[1];


	$D_IMAGENAME= $phid_filename;
	$D_URL="view.php?gid=$gid&phid=$phid"; if (basename($_SERVER['PHP_SELF'])=='galeria.php') $D_URL="image_gallery/" . $D_URL;
	if (!($D_DESC=get_data($gid_dir. $PHID_CAPTIONS, $phid)))
	    $D_DESC="";

	//If thumbnail does not exist => default thumb
	
	if (!@file_exists( $gid_dir . $thumb_name)) 
	  $D_THUMBNAIL = $TEMPLATE_DIR . "not_available.jpg";
	else 
	  $D_THUMBNAIL= $gid_dir . rawurlencode($thumb_name);  
	if (($i%$NUM_COLUMNS)==0) echo "</tr><td>";


	echo "<td valign=top>";
	include($TEMPLATE_DIR . 'view_minimage.php');
	echo "</td>";
	$i++;
    }
    echo "</table>";
    return(true);
}

/**
 * Contructs a commen line with the correct format of comments file. That is:
 *
 *     tit<|>aut<|>date<|>mail<|>web<|>msg
 *
 * Requires an array with this fields:
 *    + tit comments title
 *    + aut author
 *    + date
 *    + mail e-mail
 *    + web  web page
 *    + msg  comment text
 */

function construct_comment_line($data_array) {
  global $SEPARATOR;
  
  //Line Contruction
  $tit=str_replace("\\'","'",$data_array['tit']);
  $tit=htmlspecialchars($tit);
  $linea= $tit . $SEPARATOR;
  
  $aut=str_replace("\\'","'",$data_array['aut']);
  $aut=htmlspecialchars($aut);
  $linea=$linea . $aut . $SEPARATOR;
  
  $linea= $linea . $data_array['date'] . $SEPARATOR;
  $linea=$linea . $data_array['mail'] . $SEPARATOR;
  $linea=$linea . $data_array['web'] . $SEPARATOR;
  
  
  $msg=str_replace("\\'","'",$data_array['msg']);
  $msg=addcslashes ($msg,"\0..\37");
  $msg=str_replace("\\n","<br>",$msg);
  $msg=str_replace("\\r","",$msg);
  $msg=str_replace("<?","",$msg);
  
  $linea= $linea . $msg;
  
  return($linea);
  
}

?>
