<?php

/**
 * This module adds a comment file in  $gid_dir . $gid . "_" .$phid file
 *
 * Each File will have this format if $SEPARATOR=":";
 *
 *     title:author:date:email:web:message\n
 *
 * if a message contains "\n" character, it will be replaced with "<br />"
 *
 * The variables it receives via form:
 * 
 * -> integer $gid  the gid of the gallery
 * -> interger $phid  the phid of the image
 * -> string $tit title of the comment
 * -> string $author author name 
 * -> string $mail comment authoer email
 * -> string $web comment author web
 * -> string $msg comment itself
 * 
 * @package user 
 */

/**
 * Includes config file and common functions files
 */
include('config.php');
include('functions.php');


/**
 * Logs some information about the person who makes the comment
 *
 * This information will be stored in a file whith this format:
 *
 *  date <Separator> author <separator> IP <separator> Browser
 *
 * @global $SEPARATOR used to separate fields
 * @global $REMOTE_ADDR remote IP
 * @global $HTTP_USER_AGENT browser string
 *
 */

function logger($LOG, $aut) {
   global $SEPARATOR,$REMOTE_ADDR, $HTTP_USER_AGENT;

   if (($fp= fopen($LOG,"a+"))==NULL) {
      return(false);
   }
    $fecha=date("M d, Y H:i:s",time());
    $linea= $fecha . $SEPARATOR . $aut . $SEPARATOR . $REMOTE_ADDR . $SEPARATOR .     $HTTP_USER_AGENT ;
    //Debug Lines
    //echo "<br /> linea logger: " . $linea;
    fputs($fp, $linea . "\r\n");
    fclose($fp);
} //end log


// ############################ MAIN PROGRAM #################

$gid=$_GET['gid'];
$phid=$_GET['phid'];

$tit=$_POST['tit'];
$aut=$_POST['aut'];
$mail=$_POST['mail'];
$web=$_POST['web'];
$msg=$_POST['msg'];

//Check arguments in form. gid and phid are required.
if (!isset($gid) || !isset($phid)) error(_y("Incorrect add comment form"));

//Now check required arguments
$error=false;

if ( ((!isset($tit))||(strlen($tit)==0))&&$REQ_IN_COMMENTS['title'] ){
    warning(_y("Title field required"));
    $error=true;
}
if ( ((!isset($aut))||(strlen($aut)==0))&&$REQ_IN_COMMENTS['author'] ){
    warning(_y("Author field required"));
    $error=true;
}
if ( ((!isset($mail))||(strlen($mai)==0))&&$REQ_IN_COMMENTS['email'] ){
    warning(_y("e-mail field required"));
    $error=true;
}
if ( ((!isset($web))||(strlen($web)==0))&&$REQ_IN_COMMENTS['web'] ){
    warning(_y("Web field required"));
    $error=true;
}
if ( ((!isset($msg))||(strlen($msg)==0))&&$REQ_IN_COMMENTS['comment'] ){
    warning(_y("Comment field required"));
    $error=true;
}

if($error){
    error(_y("Sorry, you did not fill some required fields."));
}

if (!($dir=get_data($GID_DIRS, $gid))) error("Gallery does not exist.");

$gid_dir= $BASE_DIR . $dir;
$comments_file= $gid_dir . $gid . "_" . $phid;

if(!($fp=@fopen($comments_file,"a+")))
  error ("Problems whith Comments File.");

  //We add the date to post.
  $_POST['date']=date("M d, Y H:i:s",time());
  $linea=construct_comment_line($_POST);

if (filesize($comments_file)==0) {
    fputs($fp,$linea);
}
  else {
    fputs($fp,"\r\n" . $linea);
  }

// echo $linea . "<br />";//debug Line
  fclose($fp);
  logger ($BASE_DIR . "messages.log", $aut);

//Stats

add_listed_visit($gid_dir . $PHID_COMMENTS, $phid);

//Prepare variables to Show Message
$D_TITLE=$tit;
$D_AUTHOR=$aut;
$D_MAIL=$mail;
$D_WEB=$web;
$D_MESSAGE=$msg;
$D_REFRESH_URL="view.php?gid=$gid&phid=$phid";

$I_THANKS=_y("Thank you for your comment");
$I_ADDED=_y('Added this Comment');
$I_TITLE=_y('Title');
$I_AUTHOR=_y('Author');
$I_EMAIL=_y('e-mail');
$I_WEB=_y('Web');
$I_MESSAGE=_y('Comment');
$I_IF_NOT_REFRESHED=_y('If the page is not automatically refreshed.');
$I_PRESS_HERE=_y('Please, press here');

include ($TEMPLATE_DIR . "thanks_comment.php");

?>
